/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.MessageResource;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InputSimulationParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.MessageLineRTF;
import java.io.IOException;

public class IONameDisplayElement
implements DisplayElement,
MessageResource {
    protected boolean fEditable;
    protected int fType;
    protected int fBlockNumber;
    protected int fWidth;
    protected int fHeigth;
    protected int fNameID = -1;
    protected WiringDiagram fWD;
    protected int[][] nameBytes;
    protected int fCharSet;

    public IONameDisplayElement() {
    }

    public IONameDisplayElement(WiringDiagram wd, int nameID, int type, int blockNumber) {
        this.fWD = wd;
        this.fNameID = nameID;
        this.fType = type;
        this.fBlockNumber = blockNumber;
        this.fEditable = true;
        this.fWidth = 8;
        this.fHeigth = 1;
        this.nameBytes = new int[2][];
        this.nameBytes[0] = new int[8];
        this.nameBytes[1] = new int[8];
    }

    public String getStringValue() {
        Block block = this.getBlock();
        if (block instanceof InputBlock && block.getSimulationParameter() != null) {
            return this.getName(((InputSimulationParameter)block.getSimulationParameter()).getBinaryValue() ? 1 : 0);
        }
        return this.getName(block.getBinaryValue() ? 1 : 0);
    }

    public String getName(int index) {
        StringBuffer nameBuffer = new StringBuffer(8);
        if (MessageGlobalInfo.isBiWidthCharSet(this.fCharSet)) {
            int i = 0;
            while (i < 8) {
                int curByte = this.nameBytes[index][i];
                int nextByte = -1;
                if (i != 7) {
                    nextByte = this.nameBytes[index][i + 1];
                }
                if (curByte <= 127) {
                    nameBuffer.append(MessageLineRTF.getOneByteString(curByte, this.fCharSet));
                    ++i;
                    continue;
                }
                if (nextByte == -1) {
                    nameBuffer.append("?");
                    ++i;
                    continue;
                }
                nameBuffer.append(MessageLineRTF.getTwoBytesString(curByte, nextByte, this.fCharSet));
                i += 2;
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                int curByte = this.nameBytes[index][i];
                nameBuffer.append(MessageLineRTF.getOneByteString(curByte, this.fCharSet));
            }
        }
        return nameBuffer.toString();
    }

    public int[] getNameBytes(int index) {
        return this.nameBytes[index];
    }

    public void setNameByte(int index, int[] bytes) {
        System.arraycopy(bytes, 0, this.nameBytes[index], 0, Math.min(bytes.length, this.nameBytes[index].length));
    }

    public void setNameByte(int index, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            this.nameBytes[index][i] = bytes[i];
        }
    }

    public void setCharSet(int charSet) {
        this.fCharSet = charSet;
    }

    public int getCharSet() {
        return this.fCharSet;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public int getHeight() {
        return this.fHeigth;
    }

    public String toString() {
        return "IOname" + this.fNameID;
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public void setEditable(boolean editable) {
        this.fEditable = editable;
    }

    public int getID() {
        return this.fNameID;
    }

    public int getType() {
        return this.fType;
    }

    public void setType(int newType) {
        if (newType >= 0) {
            this.fType = newType;
        }
    }

    public int getNumber() {
        return this.fBlockNumber;
    }

    public void setNumber(int blockNumber) {
        if (blockNumber > 0) {
            this.fBlockNumber = blockNumber;
        }
    }

    public Block getBlock() {
        try {
            return this.fWD.getBlockByNumberExt(this.fType, this.fBlockNumber);
        }
        catch (Exception e) {
            System.out.print("error occur in name display element, block missing");
            return null;
        }
    }

    public void read(StorableInput dr) throws IOException {
        this.fNameID = dr.readInt();
        this.fType = dr.readInt();
        this.fBlockNumber = dr.readInt();
        this.fEditable = dr.readBoolean();
        this.fWidth = dr.readInt();
        this.fHeigth = dr.readInt();
        this.nameBytes = new int[2][];
        this.nameBytes[0] = new int[8];
        this.nameBytes[1] = new int[8];
    }

    public void write(StorableOutput dw) {
        dw.writeInt(this.getID());
        dw.writeInt(this.getType());
        dw.writeInt(this.getNumber());
        dw.writeBoolean(this.isEditable());
        dw.writeInt(this.fWidth);
        dw.writeInt(this.fHeigth);
    }

    public void setID(int nameID) {
        this.fNameID = nameID;
    }

    public boolean isContentsEquals(Object value) {
        if (value == null) {
            return false;
        }
        if (value.getClass() != IONameDisplayElement.class) {
            return false;
        }
        IONameDisplayElement item = (IONameDisplayElement)value;
        return item.getType() == this.getType() && item.getNumber() == this.getNumber() && item.getWidth() == this.getWidth() && item.getHeight() == this.getHeight();
    }

    public String getContentsString() {
        StringBuffer ret = new StringBuffer();
        ret.append("IOStatus: ");
        if (this.getBlock() != null) {
            ret.append(this.getBlock().getNumberString());
        }
        ret.append(";Off=\"").append(this.getName(0).trim()).append('\"');
        ret.append(";On=\"").append(this.getName(1).trim()).append('\"');
        return ret.toString();
    }

    public void transferNameToCharset(int newCharset) {
        for (int index = 0; index < 2; ++index) {
            int curByte;
            int i;
            if (MessageGlobalInfo.isBiWidthCharSet(this.fCharSet)) {
                i = 0;
                while (i < 8) {
                    curByte = this.nameBytes[index][i];
                    int nextByte = -1;
                    if (i != 7) {
                        nextByte = this.nameBytes[index][i + 1];
                    }
                    if (curByte <= 127) {
                        ++i;
                        continue;
                    }
                    if (nextByte == -1) {
                        this.nameBytes[index][i] = 32;
                        ++i;
                        continue;
                    }
                    byte[] encoding = MessageGlobalInfo.getCharsetEncoding(newCharset, MessageLineRTF.getTwoBytesString(curByte, nextByte, this.fCharSet).charAt(0));
                    if (encoding != null) {
                        this.nameBytes[index][i] = encoding[0];
                        this.nameBytes[index][i + 1] = encoding[1];
                    } else {
                        this.nameBytes[index][i] = 32;
                        this.nameBytes[index][i + 1] = 32;
                    }
                    i += 2;
                }
                continue;
            }
            for (i = 0; i < 8; ++i) {
                curByte = this.nameBytes[index][i];
                byte[] encoding = MessageGlobalInfo.getCharsetEncoding(newCharset, MessageLineRTF.getOneByteString(curByte, this.fCharSet).charAt(0));
                this.nameBytes[index][i] = encoding != null ? encoding[0] : 32;
            }
        }
    }
}

